/**
  ******************************************************************************
  * @file    openbl_core.h
  * @author  MCD Application Team
  * @brief   Header for openbl_core.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef OPENBL_CORE_H
#define OPENBL_CORE_H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <stddef.h>
#include "openbootloader_conf.h"

/* Exported types ------------------------------------------------------------*/
typedef struct
{
  void (*Init)(void);
  void (*DeInit)(void);
  uint8_t (*Detection)(void);
  void (*CommandProcess)(void);
} OPENBL_OpsTypeDef;

typedef struct
{
  void (*Read)(uint8_t* buf, uint16_t size);
  void (*Write)(uint8_t* buf, uint16_t size);
} OPENBL_IOTypeDef;

typedef struct
{
  const OPENBL_OpsTypeDef *p_Ops;
  const OPENBL_IOTypeDef *p_IO;
} OPENBL_HandleTypeDef;


void OPENBL_WriteByte(uint8_t byte);
uint8_t OPENBL_ReadByte(void);

/* Exported constants --------------------------------------------------------*/
#define ACK_BYTE                          0x79U             /* Acknowledge Byte ID */
#define NACK_BYTE                         0x1FU             /* No Acknowledge Byte ID */
#define BUSY_BYTE                         0x76U             /* Busy Byte */
#define SYNC_BYTE                         0x7FU             /* synchronization byte */

/* ---------------------- Open Bootloader Commands ---------------------------*/
#define CMD_GET_COMMAND                   0x00U             /* Get commands command */
#define CMD_GET_VERSION                   0x01U             /* Get Version command */
#define CMD_GET_ID                        0x02U             /* Get ID command */
#define CMD_READ_MEMORY                   0x11U             /* Read Memory command */
#define CMD_GO                            0x21U             /* GO command */
#define CMD_WRITE_MEMORY                  0x31U             /* Write Memory command */
#define CMD_EXT_WRITE_MEMORY              0x32U             /* Write Memory command */

#define CMD_ERASE_MEMORY                  0x41U             /* Erase Memory command */
#define CMD_EXT_ERASE_MEMORY              0x44U             /* Erase Memory command */

#define CMD_READ_PROTECT                  0x82U             /* Readout Protect command */
#define CMD_READ_UNPROTECT                0x92U             /* Readout Unprotect command */

#define CMD_WRITE_PROTECT                 0x63U             /* Write Protect command */
#define CMD_WRITE_UNPROTECT               0x73U             /* Write Unprotect command */

#define ERROR_COMMAND                     0xECU             /* Error command */


void OPENBL_Init(void);
void OPENBL_DeInit(void);
void OPENBL_DeInit_Actice(void);
void OPENBL_Read(uint8_t* buf, uint16_t size);
void OPENBL_Write(uint8_t* buf, uint16_t size);
void OPENBL_ProtocolProcess(void);
int OPENBL_InterfaceDetection(void);
int OPENBL_RegisterInterface(OPENBL_HandleTypeDef *Interface);

#endif /* OPENBL_CORE_H */
/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
